from django.urls import path, include
from . import views
from django.contrib.auth import views as auth_views
from django.views.generic import RedirectView

urlpatterns = [
    # Main Redirect
    path('', RedirectView.as_view(url='/dashboard/', permanent=False)),

    # Standalone Pages
    path('dashboard/', views.dashboard, name='dashboard'),
    path('devices/', views.devices, name='devices'),
    path('reports/', views.reports, name='reports'),
       
    # Device Actions
    # path('device/<uuid:device_id>/reset/', views.reset_counters, name='reset_counters'),

    # API endpoints
    path('api/dashboard/comprehensive_stats/', views.comprehensive_stats_api, name='comprehensive_stats_api'),
    path('api/devices/', views.device_api, name='device_api'),
    path('api/devices/<uuid:device_id>/', views.device_detail_api, name='device_detail_api'),
    path('api/reports/generate/', views.generate_report, name='generate_report'),

    # Original Device Communication APIs
    path('iot/device/telemetry/', views.device_telemetry, name='device_telemetry'),
    path('iot/device/configuration/', views.device_configuration, name='device_configuration'),

    # Auth URLs
    path('accounts/', include('django.contrib.auth.urls')),
    path('logout/', views.logout_view, name='logout'),
]