
from django.http import JsonResponse
from .models import Device

class DeviceAuthMiddleware:
    def __init__(self, get_response):
        self.get_response = get_response

    def __call__(self, request):
        if request.path.startswith('/iot/'):
            api_key = request.headers.get('X-API-Key')
            if not api_key:
                return JsonResponse({'error': 'API Key missing'}, status=401)
            try:
                device = Device.objects.get(api_key=api_key)
                request.device = device
            except Device.DoesNotExist:
                return JsonResponse({'error': 'Invalid API Key'}, status=401)
        
        response = self.get_response(request)
        return response
