from django.contrib import admin
from django.contrib.auth.admin import UserAdmin as BaseUserAdmin
from .models import User, Tenant, Device

class UserAdmin(BaseUserAdmin):
    fieldsets = (
        (None, {'fields': ('username', 'password')}),
        ('Personal info', {'fields': ('first_name', 'last_name', 'email')}),
        ('Permissions', {'fields': ('is_active', 'is_staff', 'is_superuser', 'groups', 'user_permissions')}),
        ('Important dates', {'fields': ('last_login', 'date_joined')}),
        ('Custom Fields', {'fields': ('tenant', 'role')}),
    )
    list_display = ('username', 'email', 'first_name', 'last_name', 'is_staff', 'tenant', 'role')
    list_filter = ('is_staff', 'is_superuser', 'is_active', 'groups', 'role', 'tenant')
    search_fields = ('username', 'first_name', 'last_name', 'email', 'tenant__name')
    ordering = ('username',)

admin.site.register(User, UserAdmin)
admin.site.register(Tenant)
admin.site.register(Device)